<?php

function dplog($cfg, $file, $data){
    $p = rtrim($cfg['log_dir'], '/') . '/' . $file;
    @file_put_contents($p, "[".date('Y-m-d H:i:s')."] ".json_encode($data).PHP_EOL, FILE_APPEND);
}

$cfg = require __DIR__.'/config.gateway.php';
require __DIR__.'/PayPalClient.php';

header('Content-Type: application/json');

$raw = file_get_contents('php://input');
$d   = json_decode($raw, true);

dplog($cfg, 'capture.log', ['input'=>$d]);

if (!$d) {
    echo json_encode(['success'=>false, 'error'=>'Bad JSON']);
    exit;
}

if (($d['token'] ?? '') !== $cfg['internal_token']) {
    echo json_encode(['success'=>false, 'error'=>'Bad token']);
    exit;
}

$ppid      = $d['paypal_order_id'] ?? '';
$psOrderId = $d['prestashop_order_id'] ?? null;
$env       = $d['env'] ?? $cfg['env'];

$envKey = $env==='live' ? 'live' : 'sandbox';
$pp     = $cfg['paypal'][$envKey];

try {

    $cli = new PayPalClient(
        $pp['client_id'],
        $pp['secret'],
        $envKey==='sandbox'
    );

    $cap = $cli->capture($ppid);

    dplog($cfg, 'capture.log', ['paypal'=>$cap]);

    $st  = $cap['status'] ?? '';
    $amt = 0;
    $cur = $cfg['currency_default'];

    if (isset($cap['purchase_units'][0]['payments']['captures'][0]['amount'])) {
        $a   = $cap['purchase_units'][0]['payments']['captures'][0]['amount'];
        $amt = $a['value'];
        $cur = $a['currency_code'];
    }

    echo json_encode([
        'success'             => ($st === 'COMPLETED'),
        'status'              => $st,
        'paypal_order_id'     => $ppid,
        'prestashop_order_id' => $psOrderId,
        'amount'              => $amt,
        'currency'            => $cur,
    ]);

} catch(Exception $e) {

    dplog($cfg, 'capture.log', ['error'=>$e->getMessage()]);

    echo json_encode(['success'=>false, 'error'=>$e->getMessage()]);
}
