<?php

function dplog($cfg,$file,$data){
    $p = rtrim($cfg['log_dir'],'/') . '/' . $file;
    @file_put_contents($p,"[".date('Y-m-d H:i:s')."] ".json_encode($data).PHP_EOL,FILE_APPEND);
}

$cfg = require __DIR__.'/config.gateway.php';
require __DIR__.'/PayPalClient.php';

header('Content-Type: application/json');

// ---- JSON INPUT ----
$raw = file_get_contents('php://input');
$d   = json_decode($raw, true);

// ---- LOG INPUT ----
dplog($cfg, 'create.log', ['input'=>$d]);

// ---- VALIDATION ----
if (!$d) {
    echo json_encode(['success'=>false,'error'=>'Bad JSON']);
    exit;
}

if (($d['token'] ?? '') !== $cfg['internal_token']) {
    echo json_encode(['success'=>false,'error'=>'Bad token']);
    exit;
}

$amt      = $d['amount'] ?? 0;
$cur      = $d['currency'] ?? $cfg['currency_default'];
$env      = $d['env'] ?? $cfg['env'];
$order_id = $d['order_id'] ?? '';

// ---- SELECT ENV ----
$envKey = $env === 'live' ? 'live' : 'sandbox';
$pp     = $cfg['paypal'][$envKey];

// ---- REDIRECT URLS ----
$return = $cfg['proxy_base_url'].'/redirect.php';
$cancel = $cfg['proxy_base_url'].'/redirect.php?cancel=1';

// LOG REDIRECT URLS
dplog($cfg, 'create.log', [
    'return'=>$return,
    'cancel'=>$cancel,
]);

try {

    // ---- PAYPAL CLIENT ----
    $cli = new PayPalClient(
        $pp['client_id'],
        $pp['secret'],
        $envKey === 'sandbox'
    );

    // ---- CREATE PAYPAL ORDER ----
    $resp = $cli->create(
        number_format($amt,2,'.',''),
        $cur,
        $cfg['product_name'],
        $return,
        $cancel
    );

    dplog($cfg,'create.log',['paypal'=>$resp]);

    // ---- GET APPROVE URL ----
    $approve = null;
    if (!empty($resp['links'])) {
        foreach($resp['links'] as $l){
            if ($l['rel'] === 'approve') {
                $approve = $l['href'];
                break;
            }
        }
    }

    if (!$approve) {
        echo json_encode(['success'=>false,'error'=>'No approval URL']);
        exit;
    }

    echo json_encode([
        'success'         => true,
        'approve_url'     => $approve,
        'paypal_order_id' => $resp['id'],
        'order_id'        => $order_id
    ]);

} catch(Exception $e) {

    dplog($cfg,'create.log',['error'=>$e->getMessage()]);

    echo json_encode([
        'success'=>false,
        'error'=>$e->getMessage()
    ]);
}
