<?php
function dplog($cfg,$file,$data){
  $p=rtrim($cfg['log_dir'],'/').'/'.$file;
  @file_put_contents($p,"[".date('Y-m-d H:i:s')."] ".json_encode($data).PHP_EOL,FILE_APPEND);
}

$cfg=require __DIR__.'/config.gateway.php';
require __DIR__.'/PayPalClient.php';

header('Content-Type: application/json');

$raw=file_get_contents('php://input');
$d=json_decode($raw,true);

dplog($cfg,'create.log',['input'=>$d]);

if(!$d){
  echo json_encode(['success'=>false,'error'=>'Bad JSON']);
  exit;
}

if(($d['token']??'')!==$cfg['internal_token']){
  echo json_encode(['success'=>false,'error'=>'Bad token']);
  exit;
}

$amt=$d['amount']??0;
$cur=$d['currency']??$cfg['currency_default'];
$env=$d['env']??$cfg['env'];
$order_id=$d['order_id']??'';

$envKey=$env==='live'?'live':'sandbox';
$pp=$cfg['paypal'][$envKey];

// URLs PRESTASHOP CORRECTES
$return = 'http://test.joliesat.com/module/dpgateway/return';
$cancel = 'http://test.joliesat.com/module/dpgateway/return?cancel=1';

try{
  $cli=new PayPalClient(
      $pp['client_id'],
      $pp['secret'],
      $envKey==='sandbox'
  );

  $resp=$cli->create(
      number_format($amt,2,'.',''),
      $cur,
      $cfg['product_name'],
      $return,
      $cancel
  );

  dplog($cfg,'create.log',['paypal'=>$resp]);

  $approve=null;
  foreach($resp['links'] as $l){
     if($l['rel']==='approve') $approve=$l['href'];
  }

  echo json_encode([
      'success'=>true,
      'approve_url'=>$approve,
      'paypal_order_id'=>$resp['id'],
      'order_id'=>$order_id
  ]);

}catch(Exception $e){
  dplog($cfg,'create.log',['error'=>$e->getMessage()]);
  echo json_encode(['success'=>false,'error'=>$e->getMessage()]);
}
