<?php

/**
 * redirect.php
 * - PayPal → proxy
 * - proxy → Presta callback
 */

$prestashopBase = 'https://test.joliesat.com';
$target = $prestashopBase . '/module/dpgateway/callback';

// Récup des paramètres PayPal
$params = $_GET ?: [];

// Normaliser paypal_order_id
if (!empty($params['token']) && empty($params['paypal_order_id'])) {
    $params['paypal_order_id'] = $params['token'];
}

// Si annulation utilisateur
if (isset($params['cancel'])) {
    $params['error'] = 'payment_cancelled';
}

// si order_id n’existe pas, récupérer du param custom PayPal
if (!empty($params['order_id'])) {
    // ok
}
else if (!empty($params['custom_id'])) {
    // si customId envoyé par PayPal
    $params['order_id'] = $params['custom_id'];
}
else {
    // fallback : ne jamais appeler callback sans order_id
    $params['order_id'] = 0;
}

// Reconstruction querystring
$queryString = http_build_query($params);

// Redirection finale
header('Location: ' . $target . ($queryString ? '?' . $queryString : ''));
exit;
